/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cmsc420project3;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Jeremiah
 */
public class BinaryHeapTest {

    public BinaryHeapTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception
    {
    }

    @AfterClass
    public static void tearDownClass() throws Exception
    {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of addItem method, of class BinaryHeap.
     */
    @Test
    public void testAddItem()
    {
        System.out.println("addItem");
        Object item = "test";
        int priority = 0;
        BinaryHeap instance = new BinaryHeap();
        instance.addItem(item, priority);
    }

    /**
     * Test of removeMinItem method, of class BinaryHeap.
     */
    @Test
    public void testRemoveMinItem()
    {
        System.out.println("removeMinItem");
        BinaryHeap<String> instance = new BinaryHeap();
        String expResult = "test";

        // "fuzz" test. Tests 100 items, makes sure ONLY the smallest one comes back.

        for(int x=0; x<50; x++)
        {
            instance.addItem("NOT!", (int)(Math.random()*100+6));
        }

        // Add smallest item here.
        instance.addItem(expResult, 5);

        for(int x=0; x<50; x++)
        {
            instance.addItem("NOT!", (int)(Math.random()*100+6));
        }

        String result = instance.removeMinItem();
        assertEquals(expResult, result);

    }

    /**
     * Test of recursiveBubbleFix method, of class BinaryHeap.
     */
    @Test
    public void testRecursiveBubbleFix()
    {
        System.out.println("recursiveBubbleFix");
        int position = 0;
        BinaryHeap<Integer> instance = new BinaryHeap<Integer>();

        instance.addItem(5, 5);
        instance.addItem(12, 12);
        instance.addItem(7, 7);
        instance.addItem(17, 17);
        instance.addItem(21, 21);
        instance.addItem(14, 14);

        if(instance.priorities[0]==5
                && instance.priorities[1]==12
                && instance.priorities[2]==7
                && instance.priorities[3]==17
                && instance.priorities[4]==21
                && instance.priorities[5]==14)
        {
            // good!
        } else
        {
            for(int x=0; x<instance.dataSize; x++)
            {
                System.err.println("Position " + x + " has data " + instance.priorities[x]);
            }
            fail("Heap did not create correctly.");
        }

        // Add item & check it was added
        instance.addItem(2, 2);

        if(instance.priorities[0]==2
                && instance.priorities[1]==12
                && instance.priorities[2]==5
                && instance.priorities[3]==17
                && instance.priorities[4]==21
                && instance.priorities[5]==14
                && instance.priorities[6]==7)
        {
            // good!
        } else
        {
            for(int x=0; x<instance.dataSize; x++)
            {
                System.err.println("Position " + x + " has data " + instance.priorities[x]);
            }
            fail("Item was not added correctly.");
        }

        // Remove top, which should trigger the fix.
        instance.removeMinItem();

        if(instance.priorities[0]==5
                && instance.priorities[1]==12
                && instance.priorities[2]==7
                && instance.priorities[3]==17
                && instance.priorities[4]==21
                && instance.priorities[5]==14)
        {
            // good!
        } else
        {
            for(int x=0; x<instance.dataSize; x++)
            {
                System.err.println("Position " + x + " has data " + instance.priorities[x]);
            }
            fail("Heap was not fixed correctly.");
        }
//        instance.recursiveBubbleFix(position);
    }

    /**
     * Test of getParentPos method, of class BinaryHeap.
     */
    @Test
    public void testGetParentPos()
    {
        System.out.println("getParentPos");
        int position = 5;
        BinaryHeap instance = new BinaryHeap();
        int expResult = 2;
        int result = instance.getParentPos(position);
        assertEquals(expResult, result);
    }

    /**
     * Test of getLeftChildPos method, of class BinaryHeap.
     */
    @Test
    public void testGetLeftChildPos()
    {
        System.out.println("getLeftChildPos");
        int position = 2;
        BinaryHeap instance = new BinaryHeap();
        int expResult = 5;
        int result = instance.getLeftChildPos(position);
        assertEquals(expResult, result);
    }

    /**
     * Test of getRightChildPos method, of class BinaryHeap.
     */
    @Test
    public void testGetRightChildPos()
    {
        System.out.println("getRightChildPos");
        int position = 2;
        BinaryHeap instance = new BinaryHeap();
        int expResult = 6;
        int result = instance.getRightChildPos(position);
        assertEquals(expResult, result);
    }

    /**
     * Test of swapValues method, of class BinaryHeap.
     */
    @Test
    public void testSwapValues()
    {
        System.out.println("swapValues");
        int firstPos = 0;
        int secondPos = 0;
        BinaryHeap instance = new BinaryHeap();
        instance.swapValues(firstPos, secondPos);
        // It's basically tested by other parts of the code, so not writing
        // a formal test.
    }

}